/*
     MTPowerGraphTooltip.h
     Copyright 2023-2024 SAP SE
     
     Licensed under the Apache License, Version 2.0 (the "License");
     you may not use this file except in compliance with the License.
     You may obtain a copy of the License at
     
     http://www.apache.org/licenses/LICENSE-2.0
     
     Unless required by applicable law or agreed to in writing, software
     distributed under the License is distributed on an "AS IS" BASIS,
     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     See the License for the specific language governing permissions and
     limitations under the License.
*/

#import <Cocoa/Cocoa.h>
#import "MTPowerMeasurement.h"

/*!
 @class         MTPowerGraphTooltip
 @abstract      This class defines a floating tooltip window for the power graph.
*/

@interface MTPowerGraphTooltip : NSWindow <NSWindowDelegate>

/*!
 @method        setMeasurement:
 @abstract      Set the measurement for the power graph's tooltip.
 @param         measurement The MTPowerMeasurement object that should be displayed as the tooltip.
*/
- (void)setMeasurement:(MTPowerMeasurement*)measurement;

@end
